
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bill")
mary = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Mary")
dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Dale")
bobby = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bobby")


# Set objective function
model.setObjective(7 * bill + 2 * mary + 7 * dale + 1 * bobby, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(8 * bill + 11 * bobby >= 26)
model.addConstr(10 * mary + 11 * bobby >= 26)
model.addConstr(5 * dale + 11 * bobby >= 24)
model.addConstr(10 * mary + 5 * dale >= 20)
model.addConstr(10 * mary + 5 * dale + 11 * bobby >= 18)
model.addConstr(8 * bill + 10 * mary + 11 * bobby >= 18)
model.addConstr(10 * mary + 5 * dale + 11 * bobby >= 20)
model.addConstr(8 * bill + 10 * mary + 11 * bobby >= 20)
model.addConstr(11 * dale + 8 * bobby >= 27)
model.addConstr(10 * bill + 8 * bobby >= 31)
model.addConstr(10 * bill + 11 * dale >= 22)
model.addConstr(11 * mary + 8 * bobby >= 33)
model.addConstr(11 * mary + 11 * dale >= 29)
model.addConstr(10 * bill + 11 * dale + 8 * bobby >= 35)
model.addConstr(6 * bill + 2 * bobby >= 14)
model.addConstr(5 * mary + 2 * bobby >= 12)
model.addConstr(5 * mary + 4 * dale >= 16)
model.addConstr(4 * dale + 2 * bobby >= 10)
model.addConstr(10 * mary + 11 * bobby <= 59)
model.addConstr(8 * bill + 11 * bobby <= 85)
model.addConstr(8 * bill + 5 * dale + 11 * bobby <= 84)
model.addConstr(8 * bill + 10 * mary + 5 * dale + 11 * bobby <= 84)
model.addConstr(10 * bill + 8 * bobby <= 35)
model.addConstr(11 * mary + 11 * dale <= 90)
model.addConstr(10 * bill + 11 * dale <= 105)
model.addConstr(11 * dale + 8 * bobby <= 70)
model.addConstr(11 * mary + 8 * bobby <= 48)
model.addConstr(10 * bill + 11 * mary + 11 * dale + 8 * bobby <= 48)
model.addConstr(6 * bill + 2 * bobby <= 100)
model.addConstr(4 * dale + 2 * bobby <= 65)
model.addConstr(6 * bill + 5 * mary <= 56)
model.addConstr(6 * bill + 5 * mary + 4 * dale + 2 * bobby <= 56)



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

