
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    tomatoes = m.addVar(vtype=gp.GRB.INTEGER, name="tomatoes")
    cantaloupes = m.addVar(vtype=gp.GRB.INTEGER, name="cantaloupes")
    oreos = m.addVar(vtype=gp.GRB.CONTINUOUS, name="oreos")
    bowls_of_cereal = m.addVar(vtype=gp.GRB.INTEGER, name="bowls_of_cereal")

    # Set objective function
    m.setObjective(4.51*tomatoes**2 + 5.51*tomatoes*oreos + 4.18*cantaloupes*bowls_of_cereal + 1.42*bowls_of_cereal**2 + 3.21*tomatoes + 7.49*bowls_of_cereal, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(17*cantaloupes + 18*bowls_of_cereal >= 81, "c1")
    m.addConstr(17*cantaloupes + 4*oreos + 18*bowls_of_cereal >= 120, "c2")
    m.addConstr(10*tomatoes + 13*cantaloupes + 19*oreos >= 53, "c3")
    m.addConstr(8*tomatoes - 3*bowls_of_cereal >= 0, "c4")
    m.addConstr(17*tomatoes + 4*oreos <= 280, "c5")
    m.addConstr(17*cantaloupes**2 + 4*oreos**2 <= 442, "c6")
    m.addConstr(17*cantaloupes**2 + 18*bowls_of_cereal**2 <= 436, "c7")
    m.addConstr(17*tomatoes + 17*cantaloupes + 4*oreos + 18*bowls_of_cereal <= 436, "c8")
    m.addConstr(13*cantaloupes + 19*oreos <= 87, "c9")
    m.addConstr(13*cantaloupes**2 + 22*bowls_of_cereal**2 <= 221, "c10")
    m.addConstr(19*oreos + 22*bowls_of_cereal <= 161, "c11")
    m.addConstr(10*tomatoes + 13*cantaloupes + 19*oreos + 22*bowls_of_cereal <= 161, "c12")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
