
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="tomatoes", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="cantaloupes", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="oreos", vtype=gp.GRB.CONTINUOUS)
x3 = m.addVar(name="bowls of cereal", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(4.51*x0**2 + 5.51*x0*x2 + 4.18*x1*x3 + 1.42*x3**2 + 3.21*x0 + 7.49*x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(17*x1 + 18*x3 >= 81)
m.addConstr(17*x1 + 4*x2 + 18*x3 >= 120)
m.addConstr(10*x0 + 13*x1 + 19*x2 >= 53)
m.addConstr(8*x0 - 3*x3 >= 0)
m.addConstr(17*x0 + 4*x2 <= 280)
m.addConstr(289*x1**2 + 16*x2**2 <= 442)
m.addConstr(289*x1**2 + 324*x3**2 <= 436)
m.addConstr(17*x0 + 17*x1 + 4*x2 + 18*x3 <= 436)
m.addConstr(13*x1 + 19*x2 <= 87)
m.addConstr(169*x1**2 + 484*x3**2 <= 221)
m.addConstr(19*x2 + 22*x3 <= 161)
m.addConstr(10*x0 + 13*x1 + 19*x2 + 22*x3 <= 161)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Tomatoes: ", x0.varValue)
    print("Cantaloupes: ", x1.varValue)
    print("Oreos: ", x2.varValue)
    print("Bowls of cereal: ", x3.varValue)
else:
    print("The model is infeasible")
