
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
lemons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="lemons")
strips_of_bacon = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strips_of_bacon")
blueberry_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")

# Set objective function
m.setObjective(3.73 * lemons + 5.92 * strips_of_bacon + 2.9 * blueberry_pies, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * lemons + 3 * strips_of_bacon >= 22, "c0")
m.addConstr(3 * strips_of_bacon + 1 * blueberry_pies >= 12, "c1")
m.addConstr(8 * lemons + 3 * strips_of_bacon + 1 * blueberry_pies >= 12, "c2")
m.addConstr(7 * lemons + 4 * strips_of_bacon >= 15, "c3")
m.addConstr(7 * lemons + 4 * strips_of_bacon + 5 * blueberry_pies >= 15, "c4")
m.addConstr(7 * lemons + 7 * blueberry_pies >= 15, "c5")
m.addConstr(7 * lemons + 5 * strips_of_bacon >= 33, "c6")
m.addConstr(7 * lemons + 5 * strips_of_bacon + 7 * blueberry_pies >= 33, "c7")
m.addConstr(2 * lemons - 2 * strips_of_bacon >= 0, "c8")
m.addConstr(1 * strips_of_bacon - 9 * blueberry_pies >= 0, "c9")
m.addConstr(7 * lemons + 4 * strips_of_bacon <= 84, "c10")

# Resource Constraints
m.addConstr(8 * lemons + 3 * strips_of_bacon <= 93, "r0")
m.addConstr(7 * lemons + 4 * strips_of_bacon + 5 * blueberry_pies <= 103, "r1")
m.addConstr(7 * lemons + 5 * strips_of_bacon + 7 * blueberry_pies <= 108, "r2")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('lemons:', lemons.x)
    print('strips_of_bacon:', strips_of_bacon.x)
    print('blueberry_pies:', blueberry_pies.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('The problem could not be solved to optimality.')

