
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="lemons", lb=0)
    x1 = model.addVar(name="strips of bacon", lb=0)
    x2 = model.addVar(name="blueberry pies", lb=0)

    # Define the objective function
    model.setObjective(3.73*x0 + 5.92*x1 + 2.9*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(8*x0 + 3*x1 >= 22, name="sourness_lemons_bacon")
    model.addConstr(3*x1 + x2 >= 12, name="sourness_bacon_pies")
    model.addConstr(8*x0 + 3*x1 + x2 >= 12, name="sourness_total")
    model.addConstr(7*x0 + 4*x1 >= 15, name="fat_lemons_bacon")
    model.addConstr(7*x0 + 4*x1 + 5*x2 >= 15, name="fat_total")
    model.addConstr(7*x0 + 7*x2 >= 15, name="umami_lemons_pies")
    model.addConstr(7*x0 + 5*x1 >= 33, name="umami_lemons_bacon")
    model.addConstr(7*x0 + 5*x1 + 7*x2 >= 33, name="umami_total")
    model.addConstr(2*x0 - 2*x1 >= 0, name="lemons_bacon_ratio")
    model.addConstr(x1 - 9*x2 >= 0, name="bacon_pies_ratio")
    model.addConstr(7*x0 + 4*x1 <= 84, name="fat_lemons_bacon_limit")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Lemons: ", x0.varValue)
        print("Strips of bacon: ", x1.varValue)
        print("Blueberry pies: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
