
import gurobipy as gp

# Create a new model
m = gp.Model("military_deployment")

# Create variables
signal_platoons = m.addVar(vtype=gp.GRB.INTEGER, name="signal_platoons")
artillery_batteries = m.addVar(vtype=gp.GRB.INTEGER, name="artillery_batteries")

# Set objective function
m.setObjective(9 * signal_platoons + 5 * artillery_batteries, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(13.07 * signal_platoons + 18.87 * artillery_batteries <= 31, "deployment_weight_limit")
m.addConstr(18.2 * signal_platoons + 6.47 * artillery_batteries <= 192, "logistical_capacity_upper_limit")
m.addConstr(18.2 * signal_platoons + 6.47 * artillery_batteries >= 112, "logistical_capacity_lower_limit")
m.addConstr(13.07 * signal_platoons + 18.87 * artillery_batteries >= 18, "minimum_deployment_weight")
m.addConstr(6 * signal_platoons - 4 * artillery_batteries >= 0, "signal_platoons_artillery_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Signal Platoons: {signal_platoons.x}")
    print(f"  Artillery Batteries: {artillery_batteries.x}")
    print(f"  Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

