
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="signal_platoons")
x2 = m.addVar(vtype=GRB.INTEGER, name="artillery_batteries")

# Set objective function
m.setObjective(9*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13.07*x1 + 18.87*x2 <= 31, "deployment_weight")
m.addConstr(18.2*x1 + 6.47*x2 >= 112, "logistical_capacity_min")
m.addConstr(18.2*x1 + 6.47*x2 <= 192, "logistical_capacity_max")
m.addConstr(6*x1 - 4*x2 >= 0, "linear_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Signal Platoons: {x1.x}")
    print(f"Artillery Batteries: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
