
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x1 = model.addVar(vtype=gurobi.GRB.INTEGER, name="signal_platoons")
x2 = model.addVar(vtype=gurobi.GRB.INTEGER, name="artillery_batteries")

# Objective function
model.setObjective(9 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(18.2 * x1 + 6.47 * x2 >= 112, name="logistical_capacity")
model.addConstr(6 * x1 - 4 * x2 >= 0, name="relationship")
model.addConstr(13.07 * x1 + 18.87 * x2 <= 31, name="deployment_weight")
model.addConstr(18.2 * x1 + 6.47 * x2 <= 192, name="logistical_capacity_upper")

# Optimize
model.optimize()

# Print solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Signal Platoons: ", x1.varValue)
    print("Artillery Batteries: ", x2.varValue)
else:
    print("No solution found")
