
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    iron = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="iron")
    vitamin_b5 = m.addVar(lb=0, vtype=GRB.INTEGER, name="vitamin_b5")


    # Set objective function
    m.setObjective(4.24 * iron + 9.4 * vitamin_b5, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(5 * iron + 13 * vitamin_b5 >= 22, "kidney_support_min")
    m.addConstr(6 * iron + 4 * vitamin_b5 >= 15, "immune_support_min")
    m.addConstr(6 * iron - 3 * vitamin_b5 >= 0, "iron_b5_ratio")
    
    # Resource Constraints based on provided resource limits
    m.addConstr(5 * iron + 13 * vitamin_b5 <= 54, "kidney_support_max") # Using r0 upper bound
    m.addConstr(6 * iron + 4 * vitamin_b5 <= 45, "immune_support_r1_max") # Using r1 upper bound
    m.addConstr(6 * iron + 4 * vitamin_b5 <= 29, "immune_support_max") # Using problem statement upper bound


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == GRB.OPTIMAL:
        print(f"Optimal solution found:")
        print(f"  Milligrams of iron: {iron.x}")
        print(f"  Milligrams of vitamin B5: {vitamin_b5.x}")
        print(f"  Objective value: {m.objVal}")
    elif m.status == GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
