
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_iron")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="milligrams_of_vitamin_B5")

# Define the objective function
m.setObjective(4.24*x1 + 9.4*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 13*x2 >= 22, "kidney_support_min")
m.addConstr(6*x1 + 4*x2 >= 15, "immune_support_min")
m.addConstr(6*x1 - 3*x2 >= 0, "linear_combination")
m.addConstr(5*x1 + 13*x2 <= 45, "kidney_support_max")
m.addConstr(6*x1 + 4*x2 <= 29, "immune_support_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of iron: {x1.x}")
    print(f"Milligrams of vitamin B5: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
