
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x1 = model.addVar(name="milligrams_of_iron", lb=0)  # Non-integer
x2 = model.addVar(name="milligrams_of_vitamin_B5", lb=0, type=gurobi.GRB.INTEGER)  # Integer

# Objective function
model.setObjective(4.24 * x1 + 9.4 * x2, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(5 * x1 + 13 * x2 >= 22, name="kidney_support_min")
model.addConstr(6 * x1 + 4 * x2 >= 15, name="immune_support_min")
model.addConstr(6 * x1 - 3 * x2 >= 0, name="iron_vitamin_balance")
model.addConstr(5 * x1 + 13 * x2 <= 54, name="kidney_support_max")
model.addConstr(6 * x1 + 4 * x2 <= 29, name="immune_support_max")

# Optimize
model.optimize()

# Print solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of iron: {x1.varValue}")
    print(f"Milligrams of vitamin B5: {x2.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
