
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize Labor Cost")

    # Create variables
    hank = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
    bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
    dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")


    # Set objective function
    model.setObjective(7.28 * hank + 5.42 * bill + 5.65 * dale, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(1 * hank + 9 * dale >= 24, "c0")
    model.addConstr(1 * hank + 11 * bill + 9 * dale >= 24, "c1")
    model.addConstr(1 * hank + 9 * bill >= 22, "c2")
    model.addConstr(9 * bill + 5 * dale >= 25, "c3")
    model.addConstr(1 * hank + 5 * dale >= 19, "c4")
    model.addConstr(1 * hank + 9 * bill + 5 * dale >= 18, "c5")
    model.addConstr(-9 * hank + 4 * bill >= 0, "c6")
    model.addConstr(-8 * bill + 3 * dale >= 0, "c7")
    model.addConstr(1 * hank + 11 * bill <= 77, "c8")
    model.addConstr(1 * hank + 9 * dale <= 55, "c9")
    model.addConstr(9 * bill + 5 * dale <= 38, "c10")
    model.addConstr(1 * hank + 9 * bill <= 33, "c11")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
