
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Hank
x1 = m.addVar(name="x1", lb=0)  # hours worked by Bill
x2 = m.addVar(name="x2", lb=0)  # hours worked by Dale

# Define the objective function
m.setObjective(7.28 * x0 + 5.42 * x1 + 5.65 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(x0 + 9 * x2 >= 24)  
m.addConstr(x0 + 11 * x1 + 9 * x2 >= 24)  
m.addConstr(x0 + 9 * x1 >= 22)  
m.addConstr(9 * x1 + 5 * x2 >= 25)  
m.addConstr(x0 + 5 * x2 >= 19)  
m.addConstr(x0 + 9 * x1 + 5 * x2 >= 18)  
m.addConstr(-9 * x0 + 4 * x1 >= 0)  
m.addConstr(-8 * x1 + 3 * x2 >= 0)  
m.addConstr(x0 + 11 * x1 <= 77)  
m.addConstr(x0 + 9 * x2 <= 55)  
m.addConstr(9 * x1 + 5 * x2 <= 38)  
m.addConstr(x0 + 9 * x1 <= 33)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Hours worked by Hank: ", x0.varValue)
    print("Hours worked by Bill: ", x1.varValue)
    print("Hours worked by Dale: ", x2.varValue)
else:
    print("The model is infeasible")
