
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # milligrams of vitamin B1
    x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="x1") # milligrams of vitamin A


    # Set objective function
    m.setObjective(5.56 * x0 + 7.0 * x1, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(10 * x0 + 14 * x1 >= 26, "c0")
    m.addConstr(-7 * x0 + 4 * x1 >= 0, "c1")
    m.addConstr(10 * x0 + 14 * x1 <= 104, "c2")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

