
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B1")
x2 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_A")

# Set the objective function
m.setObjective(5.56*x1 + 7.0*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 14*x2 >= 26, "cardiovascular_support_index_min")
m.addConstr(-7*x1 + 4*x2 >= 0, "vitamin_ratio_constraint")
m.addConstr(10*x1 + 14*x2 <= 104, "cardiovascular_support_index_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B1: {x1.x}")
    print(f"Milligrams of Vitamin A: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
