
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", lb=0)  # Assuming non-negative
    x2 = model.addVar(name="x2", lb=0, vtype=gurobi.GRB.INTEGER)  # Integer variable

    # Objective function
    model.setObjective(5.56 * x1 + 7.0 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(10 * x1 <= 117)
    model.addConstr(14 * x2 <= 117)
    model.addConstr(10 * x1 + 14 * x2 >= 26)
    model.addConstr(-7 * x1 + 4 * x2 >= 0)
    model.addConstr(10 * x1 + 14 * x2 <= 104)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
