
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    x0 = model.addVar(vtype=GRB.CONTINUOUS, name="x0") # hours worked by Mary
    x1 = model.addVar(vtype=GRB.INTEGER, name="x1") # hours worked by George
    x2 = model.addVar(vtype=GRB.CONTINUOUS, name="x2") # hours worked by Peggy


    # Set objective function
    model.setObjective(7*x0 + 7*x1 + 9*x2, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(13*x0 + 8*x1 >= 38, "c0")
    model.addConstr(8*x1 + 5*x2 >= 49, "c1")
    model.addConstr(8*x0 + 8*x1 + 5*x2 >= 18, "c2")
    model.addConstr(13*x0 + 5*x2 <= 93, "c3")
    model.addConstr(13*x0 + 8*x1 + 5*x2 <= 93, "c4")
    model.addConstr(12*x0 + 9*x2 <= 205, "c5")
    model.addConstr(8*x1 + 9*x2 <= 129, "c6")
    model.addConstr(12*x0 + 8*x1 + 9*x2 <= 129, "c7")
    model.addConstr(8*x0 + 8*x1 <= 57, "c8")
    model.addConstr(8*x1 + 5*x2 <= 39, "c9")
    model.addConstr(8*x0 + 8*x1 + 5*x2 <= 39, "c10")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
