
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0, ub=None)  # hours worked by Mary
x1 = m.addVar(name="x1", lb=0, ub=None, integrality=gurobi.GRB.INTEGER)  # hours worked by George
x2 = m.addVar(name="x2", lb=0, ub=None)  # hours worked by Peggy

# Objective function
m.setObjective(7*x0 + 7*x1 + 9*x2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(13*x0 + 8*x1 >= 38)  # likelihood to quit index from Mary and George
m.addConstr(8*x1 + 5*x2 >= 49)  # likelihood to quit index from George and Peggy
m.addConstr(8*x0 + 8*x1 + 5*x2 >= 18)  # dollar cost per hour from all
m.addConstr(13*x0 + 5*x2 <= 93)  # likelihood to quit index from Mary and Peggy
m.addConstr(13*x0 + 8*x1 + 5*x2 <= 93)  # likelihood to quit index from all
m.addConstr(12*x0 + 9*x2 <= 205)  # computer competence rating from Mary and Peggy
m.addConstr(8*x1 + 9*x2 <= 129)  # computer competence rating from George and Peggy
m.addConstr(12*x0 + 8*x1 + 9*x2 <= 129)  # computer competence rating from all
m.addConstr(8*x0 + 8*x1 <= 57)  # dollar cost per hour from Mary and George
m.addConstr(8*x1 + 5*x2 <= 39)  # dollar cost per hour from George and Peggy
m.addConstr(8*x0 + 8*x1 + 5*x2 <= 39)  # dollar cost per hour from all

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Mary: ", x0.varValue)
    print("Hours worked by George: ", x1.varValue)
    print("Hours worked by Peggy: ", x2.varValue)
else:
    print("The model is infeasible")
