
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="cartons_of_milk")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="packs_of_paper_plates")

    # Set objective function
    m.setObjective(9*x0 + 2*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2*x0 + 5*x1 >= 16, "weight_lower_bound")
    m.addConstr(1*x0 + 11*x1 >= 10, "sustainability_lower_bound")
    m.addConstr(1*x0 + 1*x1 >= 8, "dollar_value_lower_bound")
    m.addConstr(3*x0 + 1*x1 >= 10, "storage_space_lower_bound")
    m.addConstr(-2*x0 + 8*x1 >= 0, "custom_constraint_1")
    m.addConstr(2*x0 + 5*x1 <= 49, "weight_upper_bound")
    m.addConstr(1*x0 + 11*x1 <= 48, "sustainability_upper_bound")
    m.addConstr(1*x0 + 1*x1 <= 26, "dollar_value_upper_bound")
    m.addConstr(3*x0 + 1*x1 <= 22, "storage_space_upper_bound")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('cartons_of_milk:', x0.x)
        print('packs_of_paper_plates:', x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
