
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="cartons_of_milk")
x1 = m.addVar(vtype=GRB.INTEGER, name="packs_of_paper_plates")

# Set the objective function
m.setObjective(9*x0 + 2*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x0 + 5*x1 >= 16, "total_weight_min")
m.addConstr(x0 + 11*x1 >= 10, "sustainability_score_min")
m.addConstr(x0 + x1 >= 8, "combined_value_min")
m.addConstr(3*x0 + x1 >= 10, "storage_space_min")
m.addConstr(-2*x0 + 8*x1 >= 0, "additional_constraint")
m.addConstr(2*x0 + 5*x1 <= 49, "total_weight_max")
m.addConstr(x0 + 11*x1 <= 48, "sustainability_score_max")
m.addConstr(x0 + x1 <= 26, "combined_value_max")
m.addConstr(3*x0 + x1 <= 22, "storage_space_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Cartons of milk:", x0.x)
    print("Packs of paper plates:", x1.x)
    print("Objective value:", m.objVal)
else:
    print("No optimal solution found.")
