
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="cartons_of_milk", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="packs_of_paper_plates", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(9 * x1 + 2 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2 * x1 + 5 * x2 >= 16, name="weight_constraint")
    model.addConstr(x1 + 11 * x2 >= 10, name="sustainability_score_constraint")
    model.addConstr(x1 + x2 >= 8, name="value_constraint")
    model.addConstr(3 * x1 + x2 >= 10, name="storage_space_constraint")
    model.addConstr(-2 * x1 + 8 * x2 >= 0, name="linear_constraint")
    model.addConstr(2 * x1 + 5 * x2 <= 49, name="max_weight_constraint")
    model.addConstr(x1 + 11 * x2 <= 48, name="max_sustainability_score_constraint")
    model.addConstr(x1 + x2 <= 26, name="max_value_constraint")
    model.addConstr(3 * x1 + x2 <= 22, name="max_storage_space_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cartons of milk: {x1.varValue}")
        print(f"Packs of paper plates: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
