
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
jean = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Jean")
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Ringo")
john = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="John")
paul = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Paul")


# Set objective function
m.setObjective(7.17 * jean + 7.08 * ringo + 7.84 * john + 7.77 * paul, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.75 * ringo + 11.48 * john + 6.79 * paul >= 21)
m.addConstr(3.56 * jean + 1.75 * ringo + 11.48 * john >= 21)
m.addConstr(3.56 * jean + 11.48 * john + 6.79 * paul >= 21)
m.addConstr(1.75 * ringo + 11.48 * john + 6.79 * paul >= 39)
m.addConstr(3.56 * jean + 1.75 * ringo + 11.48 * john >= 39)
m.addConstr(3.56 * jean + 11.48 * john + 6.79 * paul >= 39)
m.addConstr(1.75 * ringo + 11.48 * john + 6.79 * paul >= 30)
m.addConstr(3.56 * jean + 1.75 * ringo + 11.48 * john >= 30)
m.addConstr(3.56 * jean + 11.48 * john + 6.79 * paul >= 30)
m.addConstr(1.29 * john + 6.69 * paul >= 22)
m.addConstr(9.02 * jean + 15.5 * ringo + 1.29 * john >= 24)
m.addConstr(9.02 * jean + 15.5 * ringo + 6.69 * paul >= 24)
m.addConstr(9.02 * jean + 15.5 * ringo + 1.29 * john >= 21)
m.addConstr(9.02 * jean + 15.5 * ringo + 6.69 * paul >= 21)
m.addConstr(3.56 * jean + 6.79 * paul <= 106)
m.addConstr(1.75 * ringo + 11.48 * john + 6.79 * paul <= 164)
m.addConstr(3.56 * jean + 1.75 * ringo + 6.79 * paul <= 157)
m.addConstr(3.56 * jean + 1.75 * ringo + 11.48 * john + 6.79 * paul <= 157)
m.addConstr(15.5 * ringo + 6.69 * paul <= 81)
m.addConstr(9.02 * jean + 6.69 * paul <= 87)
m.addConstr(15.5 * ringo + 1.29 * john + 6.69 * paul <= 66)
m.addConstr(9.02 * jean + 15.5 * ringo + 1.29 * john <= 81)
m.addConstr(9.02 * jean + 15.5 * ringo + 6.69 * paul <= 50)
m.addConstr(9.02 * jean + 15.5 * ringo + 1.29 * john + 6.69 * paul <= 50)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

