
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Jean
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Ringo
    x2 = model.addVar(name="x2", lb=0)  # hours worked by John
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Paul

    # Objective function
    model.setObjective(7.17 * x0 + 7.08 * x1 + 7.84 * x2 + 7.77 * x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3.56 * x0 <= 173)
    model.addConstr(9.02 * x0 <= 108)
    model.addConstr(1.75 * x1 <= 173)
    model.addConstr(15.5 * x1 <= 108)
    model.addConstr(11.48 * x2 <= 173)
    model.addConstr(1.29 * x2 <= 108)
    model.addConstr(6.79 * x3 <= 173)
    model.addConstr(6.69 * x3 <= 108)
    model.addConstr(1.75 * x1 + 11.48 * x2 + 6.79 * x3 >= 21)
    model.addConstr(3.56 * x0 + 1.75 * x1 + 11.48 * x2 >= 21)
    model.addConstr(3.56 * x0 + 11.48 * x2 + 6.79 * x3 >= 21)
    model.addConstr(1.75 * x1 + 11.48 * x2 + 6.79 * x3 >= 39)
    model.addConstr(3.56 * x0 + 1.75 * x1 + 11.48 * x2 >= 39)
    model.addConstr(3.56 * x0 + 11.48 * x2 + 6.79 * x3 >= 39)
    model.addConstr(1.75 * x1 + 11.48 * x2 + 6.79 * x3 >= 30)
    model.addConstr(3.56 * x0 + 1.75 * x1 + 11.48 * x2 >= 30)
    model.addConstr(3.56 * x0 + 11.48 * x2 + 6.79 * x3 >= 30)
    model.addConstr(1.29 * x2 + 6.69 * x3 >= 22)
    model.addConstr(9.02 * x0 + 15.5 * x1 + 1.29 * x2 >= 24)
    model.addConstr(9.02 * x0 + 15.5 * x1 + 6.69 * x3 >= 24)
    model.addConstr(9.02 * x0 + 15.5 * x1 + 1.29 * x2 >= 21)
    model.addConstr(9.02 * x0 + 15.5 * x1 + 6.69 * x3 >= 21)
    model.addConstr(3.56 * x0 + 6.79 * x3 <= 106)
    model.addConstr(1.75 * x1 + 11.48 * x2 + 6.79 * x3 <= 164)
    model.addConstr(3.56 * x0 + 1.75 * x1 + 6.79 * x3 <= 157)
    model.addConstr(3.56 * x0 + 1.75 * x1 + 11.48 * x2 + 6.79 * x3 <= 157)
    model.addConstr(15.5 * x1 + 6.69 * x3 <= 81)
    model.addConstr(9.02 * x0 + 6.69 * x3 <= 87)
    model.addConstr(15.5 * x1 + 1.29 * x2 + 6.69 * x3 <= 66)
    model.addConstr(9.02 * x0 + 15.5 * x1 + 1.29 * x2 <= 81)
    model.addConstr(9.02 * x0 + 15.5 * x1 + 6.69 * x3 <= 50)
    model.addConstr(9.02 * x0 + 15.5 * x1 + 1.29 * x2 + 6.69 * x3 <= 50)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Jean: ", x0.varValue)
        print("Hours worked by Ringo: ", x1.varValue)
        print("Hours worked by John: ", x2.varValue)
        print("Hours worked by Paul: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
