
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    protein = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein")
    carbs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbs")


    # Set objective function
    m.setObjective(9 * protein + 4 * carbs, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(5.39 * protein + 7.75 * carbs >= 26, "immune_support_min")
    m.addConstr(4.14 * protein + 0.59 * carbs >= 19, "cardio_support_min")
    m.addConstr(-8 * protein + 3 * carbs >= 0, "protein_carbs_ratio")
    m.addConstr(5.39 * protein + 7.75 * carbs <= 30, "immune_support_max")
    m.addConstr(4.14 * protein + 0.59 * carbs <= 54, "cardio_support_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Optimal objective: %g' % m.objVal)
        print('Protein: %g' % protein.x)
        print('Carbs: %g' % carbs.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')

