
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, name="grams_of_protein")
x1 = m.addVar(lb=0, name="grams_of_carbohydrates")

# Set the objective function
m.setObjective(9*x0 + 4*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(5.39*x0 + 7.75*x1 >= 26, name="immune_support_min")
m.addConstr(4.14*x0 + 0.59*x1 >= 19, name="cardiovascular_support_min")
m.addConstr(-8*x0 + 3*x1 >= 0, name="protein_carb_ratio")
m.addConstr(5.39*x0 + 7.75*x1 <= 30, name="immune_support_max")
m.addConstr(4.14*x0 + 0.59*x1 <= 54, name="cardiovascular_support_max")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of protein: {x0.x}")
    print(f"Grams of carbohydrates: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
