
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="protein", lb=0)  # grams of protein
    x2 = model.addVar(name="carbohydrates", lb=0)  # grams of carbohydrates

    # Define the objective function
    model.setObjective(9 * x1 + 4 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(5.39 * x1 + 7.75 * x2 >= 26)
    model.addConstr(4.14 * x1 + 0.59 * x2 >= 19)
    model.addConstr(-8 * x1 + 3 * x2 >= 0)
    model.addConstr(5.39 * x1 + 7.75 * x2 <= 30)
    model.addConstr(4.14 * x1 + 0.59 * x2 <= 54)

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Grams of protein: {x1.varValue}")
        print(f"Grams of carbohydrates: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

optimize_problem()
