
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="smoke_detectors")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="3D_printers")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="scissors")
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="color_printers")


    # Set objective function
    m.setObjective(9.17 * x0 + 3.54 * x1 + 6.68 * x2 + 7.93 * x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4 * x0 + 2 * x1 + 21 * x2 + 8 * x3 <= 303, "c0")
    m.addConstr(2 * x1 + 21 * x2 >= 63, "c1")
    m.addConstr(2 * x1 + 8 * x3 >= 54, "c2")
    m.addConstr(21 * x2 + 8 * x3 >= 39, "c3")
    m.addConstr(4 * x0 + 21 * x2 + 8 * x3 >= 58, "c4")
    m.addConstr(4 * x0 + 2 * x1 + 21 * x2 >= 58, "c5")
    m.addConstr(4 * x0 + 21 * x2 + 8 * x3 >= 45, "c6") # Redundant
    m.addConstr(4 * x0 + 2 * x1 + 21 * x2 >= 45, "c7") # Redundant
    m.addConstr(2 * x1 + 21 * x2 <= 83, "c8")
    m.addConstr(4 * x0 + 2 * x1 <= 278, "c9")
    m.addConstr(4 * x0 + 2 * x1 + 21 * x2 + 8 * x3 <= 303, "c10") # Redundant


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
