
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='smoke_detectors', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='3D_printers', vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='scissors', vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name='color_printers', vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(9.17*x1 + 3.54*x2 + 6.68*x3 + 7.93*x4, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2*x2 + 21*x3 >= 63)
    model.addConstr(2*x2 + 8*x4 >= 54)
    model.addConstr(21*x3 + 8*x4 >= 39)
    model.addConstr(4*x1 + 21*x3 + 8*x4 >= 58)
    model.addConstr(4*x1 + 2*x2 + 21*x3 >= 58)
    model.addConstr(4*x1 + 21*x3 + 8*x4 >= 45)
    model.addConstr(4*x1 + 2*x2 + 21*x3 >= 45)
    model.addConstr(2*x2 + 21*x3 <= 83)
    model.addConstr(4*x1 + 2*x2 <= 278)
    model.addConstr(4*x1 + 2*x2 + 21*x3 + 8*x4 <= 303) # corrected upper bound

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Smoke Detectors: ', x1.varValue)
        print('3D Printers: ', x2.varValue)
        print('Scissors: ', x3.varValue)
        print('Color Printers: ', x4.varValue)
    else:
        print('No optimal solution found')

optimize_problem()
