
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
john = m.addVar(vtype=gp.GRB.INTEGER, name="john")
hank = m.addVar(vtype=gp.GRB.INTEGER, name="hank")
peggy = m.addVar(vtype=gp.GRB.INTEGER, name="peggy")
bill = m.addVar(vtype=gp.GRB.INTEGER, name="bill")
paul = m.addVar(vtype=gp.GRB.INTEGER, name="paul")
george = m.addVar(vtype=gp.GRB.INTEGER, name="george")


# Set objective function
m.setObjective(1 * john + 7 * hank + 1 * peggy + 4 * bill + 2 * paul + 8 * george, gp.GRB.MAXIMIZE)


paperwork_competence = {
    "john": 13,
    "hank": 19,
    "peggy": 13,
    "bill": 17,
    "paul": 3,
    "george": 5
}

organization_score = {
    "john": 12,
    "hank": 2,
    "peggy": 6,
    "bill": 15,
    "paul": 18,
    "george": 2
}

# Add constraints

m.addConstr(13 * peggy + 3 * paul >= 35)
m.addConstr(13 * peggy + 17 * bill >= 27)
m.addConstr(6*peggy + 18*paul <= 287)


# ... (rest of the constraints from the JSON "constraints" field)

m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

