
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
pizza = m.addVar(vtype=GRB.INTEGER, name="pizza")
kiwis = m.addVar(vtype=GRB.INTEGER, name="kiwis")
ravioli = m.addVar(vtype=GRB.INTEGER, name="ravioli")
potatoes = m.addVar(vtype=GRB.CONTINUOUS, name="potatoes")
bacon = m.addVar(vtype=GRB.INTEGER, name="bacon")
knishes = m.addVar(vtype=GRB.CONTINUOUS, name="knishes")


# Set objective function
m.setObjective(4 * pizza + 3 * kiwis + 7 * ravioli + 2 * potatoes + 8 * bacon + 5 * knishes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(17 * pizza + 3 * potatoes >= 24)
m.addConstr(3 * potatoes + 23 * bacon + 12 * knishes >= 24)
m.addConstr(17 * pizza + 3 * potatoes + 12 * knishes >= 24)
m.addConstr(20 * ravioli + 23 * bacon + 12 * knishes >= 24)
m.addConstr(17 * pizza + 3 * potatoes + 23 * bacon >= 24)
m.addConstr(17 * pizza + 20 * ravioli + 12 * knishes >= 24)
m.addConstr(17 * pizza + 3 * kiwis + 12 * knishes >= 24)
m.addConstr(3 * potatoes + 23 * bacon + 12 * knishes >= 23)
m.addConstr(17 * pizza + 3 * potatoes + 12 * knishes >= 23)
m.addConstr(20 * ravioli + 23 * bacon + 12 * knishes >= 23)
m.addConstr(17 * pizza + 3 * potatoes + 23 * bacon >= 23)
m.addConstr(17 * pizza + 20 * ravioli + 12 * knishes >= 23)
m.addConstr(17 * pizza + 3 * kiwis + 12 * knishes >= 23)
m.addConstr(3 * potatoes + 23 * bacon + 12 * knishes >= 31)
m.addConstr(17 * pizza + 3 * potatoes + 12 * knishes >= 31)
m.addConstr(20 * ravioli + 23 * bacon + 12 * knishes >= 31)
m.addConstr(17 * pizza + 3 * potatoes + 23 * bacon >= 31)
m.addConstr(17 * pizza + 20 * ravioli + 12 * knishes >= 31)
m.addConstr(17 * pizza + 3 * kiwis + 12 * knishes >= 31)
m.addConstr(-9 * ravioli + 4 * potatoes >= 0)
m.addConstr(20 * ravioli + 3 * potatoes <= 106)
m.addConstr(20 * ravioli + 12 * knishes <= 106)
m.addConstr(3 * kiwis + 20 * ravioli <= 182)
m.addConstr(3 * kiwis + 3 * potatoes <= 167)
m.addConstr(17 * pizza + 20 * ravioli <= 178)
m.addConstr(17 * pizza + 12 * knishes <= 109)
m.addConstr(17 * pizza + 23 * bacon <= 123)
m.addConstr(20 * ravioli + 23 * bacon <= 111)
m.addConstr(3 * kiwis + 12 * knishes <= 133)
m.addConstr(3 * kiwis + 23 * bacon <= 144)
m.addConstr(17 * pizza + 3 * kiwis + 12 * knishes <= 132)
m.addConstr(3 * kiwis + 23 * bacon + 12 * knishes <= 116)
m.addConstr(17 * pizza + 3 * potatoes + 23 * bacon <= 176)
m.addConstr(17 * pizza + 3 * kiwis + 23 * bacon <= 53)
m.addConstr(3 * kiwis + 3 * potatoes + 23 * bacon <= 115)
m.addConstr(3 * kiwis + 20 * ravioli + 12 * knishes <= 42)
m.addConstr(17 * pizza + 3 * kiwis + 20 * ravioli + 3 * potatoes + 23 * bacon + 12 * knishes <= 42)
m.addConstr(17 * pizza + 3 * kiwis + 20 * ravioli + 3 * potatoes + 23 * bacon + 12 * knishes <= 188)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

