
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(6, lb=0, names=['John', 'Bobby', 'Peggy', 'Jean', 'Ringo', 'Bill'])

# Set objective function
m.setObjective(8*x[0]**2 + 7*x[1]*x[2] + 6*x[1]*x[4] + 5*x[2]*x[3] + 2*x[2]*x[4] + 5*x[0] + 9*x[3], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x[0] + 1*x[5] >= 42)
m.addConstr(16*x[2]**2 + 3*x[3]**2 >= 43)
# ... (add all other constraints similarly)
m.addConstr(3*x[0] + 15*x[1] <= 285)
m.addConstr(15*x[0] + 8*x[1] + 4*x[2] + 6*x[3] + 7*x[4] + 5*x[5] <= 542)
m.addConstr(3*x[0] + 15*x[1] + 7*x[2] + 14*x[3] + 2*x[4] + 4*x[5] <= 416)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
    print(f'Objective Value: {m.objVal}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

