
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x = m.addVars(6, name="x")

# Define the objective function
m.setObjective(8*x[0]**2 + 7*x[0]*x[1] + 0*x[1]*x[2] + 6*x[1]*x[4] + 5*x[2]*x[3] + 2*x[2]*x[4] + 5*x[0] + 9*x[3], gp.GRB.MAXIMIZE)

# Define the constraints
# Attributes
attributes = {
    'r0': {'x0': 12, 'x1': 14, 'x2': 16, 'x3': 3, 'x4': 15, 'x5': 1, 'upper_bound': 285},
    'r1': {'x0': 15, 'x1': 8, 'x2': 4, 'x3': 6, 'x4': 7, 'x5': 5, 'upper_bound': 542},
    'r2': {'x0': 3, 'x1': 15, 'x2': 7, 'x3': 14, 'x4': 2, 'x5': 4, 'upper_bound': 416}
}

# Individual constraints
m.addConstr(12*x[0] == 12)
m.addConstr(15*x[0] == 15)
m.addConstr(3*x[0] == 3)
m.addConstr(14*x[1] == 14)
m.addConstr(8*x[1] == 8)
m.addConstr(15*x[1] == 15)
m.addConstr(16*x[2] == 16)
m.addConstr(4*x[2] == 4)
m.addConstr(7*x[2] == 7)
m.addConstr(3*x[3] == 3)
m.addConstr(6*x[3] == 6)
m.addConstr(14*x[3] == 14)
m.addConstr(15*x[4] == 15)
m.addConstr(7*x[4] == 7)
m.addConstr(2*x[4] == 2)
m.addConstr(x[5] == 1)
m.addConstr(5*x[5] == 5)
m.addConstr(4*x[5] == 4)

# Paperwork competence rating constraints
m.addConstr(12*x[0] + 1*x[5] >= 42)
m.addConstr(16*x[2]**2 + 3*x[3]**2 >= 43)
m.addConstr(12*x[0] + 16*x[2] >= 26)
m.addConstr(14*x[1] + 16*x[2] >= 21)
m.addConstr(15*x[4] + 1*x[5] >= 28)
m.addConstr(3*x[3] + 15*x[4] >= 46)
m.addConstr(14*x[1]**2 + 1*x[5]**2 >= 31)
m.addConstr(16*x[2] + 15*x[4] >= 18)
m.addConstr(12*x[0]**2 + 15*x[4]**2 >= 40)
m.addConstr(16*x[2] + 3*x[3] + 15*x[4] >= 24)
m.addConstr(12*x[0] + 3*x[3] + 15*x[4] >= 24)
m.addConstr(12*x[0]**2 + 14*x[1]**2 + 15*x[4]**2 >= 24)
m.addConstr(12*x[0] + 15*x[4] + 1*x[5] >= 24)
m.addConstr(14*x[1] + 3*x[3] + 1*x[5] >= 24)
m.addConstr(14*x[1]**2 + 16*x[2]**2 + 3*x[3]**2 >= 24)
m.addConstr(12*x[0] + 14*x[1] + 16*x[2] >= 24)
m.addConstr(12*x[0] + 14*x[1] + 3*x[3] >= 24)
m.addConstr(14*x[1] + 16*x[2] + 1*x[5] >= 24)
m.addConstr(16*x[2] + 3*x[3] + 15*x[4] >= 37)
m.addConstr(12*x[0] + 3*x[3] + 15*x[4] >= 37)
m.addConstr(12*x[0]**2 + 14*x[1]**2 + 15*x[4]**2 >= 37)
m.addConstr(12*x[0]**2 + 15*x[4]**2 + 1*x[5]**2 >= 37)
m.addConstr(14*x[1]**2 + 3*x[3]**2 + 1*x[5]**2 >= 37)
m.addConstr(14*x[1] + 16*x[2] + 3*x[3] >= 37)
m.addConstr(12*x[0] + 14*x[1] + 16*x[2] >= 37)
m.addConstr(12*x[0] + 14*x[1] + 3*x[3] >= 37)
m.addConstr(14*x[1] + 16*x[2] + 1*x[5] >= 37)

# Organization score constraints
m.addConstr(3*x[0]**2 + 15*x[1]**2 >= 23)
m.addConstr(3*x[0] + 15*x[4] >= 27)
m.addConstr(3*x[0]**2 + 14*x[3]**2 >= 57)
m.addConstr(15*x[1] + 4*x[5] >= 49)
m.addConstr(14*x[3] + 4*x[5] >= 64)
m.addConstr(7*x[2]**2 + 2*x[4]**2 >= 66)

# Likelihood to quit index constraints
m.addConstr(8*x[1] + 7*x[4] <= 431)
m.addConstr(15*x[0] + 4*x[2] <= 518)
m.addConstr(8*x[1] + 5*x[5] <= 375)
m.addConstr(7*x[4] + 5*x[5] <= 195)
m.addConstr(8*x[1] + 6*x[3] + 5*x[5] <= 273)
m.addConstr(15*x[0]**2 + 4*x[2]**2 + 7*x[4]**2 <= 385)
m.addConstr(15*x[0] + 14*x[3] + 5*x[5] <= 435)
m.addConstr(8*x[1] + 4*x[2] + 6*x[3] <= 318)
m.addConstr(15*x[0] + 4*x[2] + 5*x[5] <= 150)
m.addConstr(4*x[2] + 6*x[3] + 7*x[4] + 5*x[5] <= 189)
m.addConstr(8*x[1] + 7*x[4] + 5*x[5] <= 180)
m.addConstr(15*x[0] + 7*x[4] + 5*x[5] <= 254)
m.addConstr(15*x[0] + 14*x[3] + 7*x[4] <= 374)
m.addConstr(15*x[0] + 4*x[2] + 14*x[3] <= 99)
m.addConstr(15*x[0] + 8*x[1] + 4*x[2] <= 159)

# Solve the model
m.optimize()

# Print the solution
for i in range(6):
    print(f"x[{i}] = {x[i].varValue}")
