
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberries")

    # Set objective function
    m.setObjective(7*x0**2 + 3*x0*x1 + 8*x0*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2*x0 + 10*x1 + 5*x2 <= 55, "c0")
    m.addConstr(8*x0 + 5*x1 + 3*x2 <= 59, "c1")  # Original constraint
    m.addConstr(2*x0 + 9*x1 + 4*x2 <= 67, "c2")  # Original constraint
    m.addConstr(8*x0 + 5*x1 + 3*x2 >= 17, "c3")
    m.addConstr(2*x0 + 5*x2 <= 41, "c4")
    m.addConstr(2*x0 + 10*x1 <= 49, "c5")
    m.addConstr(8*x0 + 3*x2 <= 50, "c6")
    m.addConstr(5*x1 + 3*x2 <= 43, "c7")
    m.addConstr(8*x0 + 5*x1 + 3*x2 <= 43, "c8")  # Stricter calcium constraint
    m.addConstr(9*x1**2 + 4*x2**2 <= 45, "c9")
    m.addConstr(2*x0 + 4*x2 <= 52, "c10")
    m.addConstr(2*x0**2 + 9*x1**2 <= 27, "c11")
    m.addConstr(2*x0 + 9*x1 + 4*x2 <= 27, "c12")  # Stricter carb constraint


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
