
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="peanutbutter_sandwiches", lb=0)  # lower bound is 0, no upper bound
x1 = m.addVar(name="blueberry_pies", lb=0)  # lower bound is 0, no upper bound
x2 = m.addVar(name="strawberries", lb=0)  # lower bound is 0, no upper bound

# Objective function
m.setObjective(7*x0**2 + 3*x0*x1 + 8*x0*x2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(2*x0 + 10*x1 + 5*x2 <= 55)
m.addConstr(8*x0 + 5*x1 + 3*x2 <= 59)
m.addConstr(2*x0 + 9*x1 + 4*x2 <= 67)
m.addConstr(8*x0 + 5*x1 + 3*x2 >= 17)
m.addConstr(2*x0 + 5*x2 <= 41)
m.addConstr(2*x0 + 10*x1 <= 49)
m.addConstr(2*x0 + 10*x1 + 5*x2 <= 49)
m.addConstr(8*x0 + 3*x2 <= 50)
m.addConstr(5*x1 + 3*x2 <= 43)
m.addConstr(8*x0 + 5*x1 + 3*x2 <= 43)
m.addConstr(9*x1**2 + 4*x2**2 <= 45)
m.addConstr(2*x0 + 4*x2 <= 52)
m.addConstr(4*x0**2 + 9*x1**2 <= 27)
m.addConstr(2*x0 + 9*x1 + 4*x2 <= 27)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Peanutbutter sandwiches: ", x0.varValue)
    print("Blueberry pies: ", x1.varValue)
    print("Strawberries: ", x2.varValue)
else:
    print("The model is infeasible")
