
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
potatoes = m.addVar(vtype=gp.GRB.INTEGER, name="potatoes")
hamburgers = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hamburgers")
peanutbutter_sandwiches = m.addVar(vtype=gp.GRB.INTEGER, name="peanutbutter_sandwiches")
strawberries = m.addVar(vtype=gp.GRB.CONTINUOUS, name="strawberries")


# Set objective function
m.setObjective(potatoes**2 + 7*potatoes*strawberries + hamburgers*strawberries + 4*peanutbutter_sandwiches**2 + 5*potatoes + 7*peanutbutter_sandwiches, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.89*hamburgers**2 + 0.62*strawberries**2 >= 13)
m.addConstr(0.65*potatoes + 0.32*peanutbutter_sandwiches + 0.62*strawberries >= 19)
m.addConstr(0.64*hamburgers + 0.89*peanutbutter_sandwiches >= 13)
m.addConstr(8*potatoes - 8*hamburgers - 8*peanutbutter_sandwiches >= 0)
m.addConstr(0.65*potatoes + 0.32*peanutbutter_sandwiches <= 76)
m.addConstr(0.89*hamburgers**2 + 0.62*strawberries**2 <= 95)
m.addConstr(0.32*peanutbutter_sandwiches**2 + 0.62*strawberries**2 <= 35)
m.addConstr(0.65*potatoes + 0.89*hamburgers + 0.32*peanutbutter_sandwiches + 0.62*strawberries <= 35)
m.addConstr(0.39*peanutbutter_sandwiches + 0.0*strawberries <= 86)
m.addConstr(0.59*potatoes + 0.0*strawberries <= 103)
m.addConstr(0.59*potatoes + 0.39*peanutbutter_sandwiches + 0.0*strawberries <= 78)
m.addConstr(0.59*potatoes + 0.85*hamburgers + 0.39*peanutbutter_sandwiches <= 128)
m.addConstr(0.85*hamburgers + 0.39*peanutbutter_sandwiches + 0.0*strawberries <= 131)
m.addConstr(0.59*potatoes + 0.85*hamburgers + 0.39*peanutbutter_sandwiches + 0.0*strawberries <= 131)
m.addConstr(0.64*hamburgers + 0.89*peanutbutter_sandwiches <= 73)
m.addConstr(0.23*potatoes + 0.18*strawberries <= 38)
m.addConstr(0.23*potatoes + 0.89*peanutbutter_sandwiches <= 82)
m.addConstr(0.89*peanutbutter_sandwiches + 0.18*strawberries <= 44)
m.addConstr(0.23*potatoes + 0.89*peanutbutter_sandwiches + 0.18*strawberries <= 89)
m.addConstr(0.23*potatoes + 0.64*hamburgers + 0.18*strawberries <= 70)
m.addConstr(0.23*potatoes + 0.64*hamburgers + 0.89*peanutbutter_sandwiches + 0.18*strawberries <= 70)


# Resource Constraints
m.addConstr(0.65 * potatoes <= 121)
m.addConstr(0.59 * potatoes <= 137)
m.addConstr(0.23 * potatoes <= 125)
m.addConstr(0.89 * hamburgers <= 121)
m.addConstr(0.85 * hamburgers <= 137)
m.addConstr(0.64 * hamburgers <= 125)
m.addConstr(0.32 * peanutbutter_sandwiches <= 121)
m.addConstr(0.39 * peanutbutter_sandwiches <= 137)
m.addConstr(0.89 * peanutbutter_sandwiches <= 125)
m.addConstr(0.62 * strawberries <= 121)
m.addConstr(0.0 * strawberries <= 137)
m.addConstr(0.18 * strawberries <= 125)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

