
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='potatoes', vtype=gurobi.GRB.INTEGER, lb=0)
x2 = m.addVar(name='hamburgers', vtype=gurobi.GRB.CONTINUOUS, lb=0)
x3 = m.addVar(name='peanutbutter sandwiches', vtype=gurobi.GRB.INTEGER, lb=0)
x4 = m.addVar(name='strawberries', vtype=gurobi.GRB.CONTINUOUS, lb=0)

# Objective function
m.setObjective(1 * x1**2 + 7 * x1 * x4 + 1 * x2 * x4 + 4 * x3**2 + 5 * x1 + 7 * x3, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(0.65 * x1 <= 121)
m.addConstr(0.59 * x1 <= 137)
m.addConstr(0.23 * x1 <= 125)
m.addConstr(0.89 * x2 <= 121)
m.addConstr(0.85 * x2 <= 137)
m.addConstr(0.64 * x2 <= 125)
m.addConstr(0.32 * x3 <= 121)
m.addConstr(0.39 * x3 <= 137)
m.addConstr(0.89 * x3 <= 125)
m.addConstr(0.62 * x4 <= 121)
m.addConstr(0.0 * x4 <= 137)
m.addConstr(0.18 * x4 <= 125)
m.addConstr(0.89 * x2**2 + 0.62 * x4**2 >= 13)
m.addConstr(0.65 * x1 + 0.32 * x3 + 0.62 * x4 >= 19)
m.addConstr(0.64 * x2 + 0.89 * x3 >= 13)
m.addConstr(8 * x1 - 8 * x2 - 8 * x3 >= 0)
m.addConstr(0.65 * x1 + 0.32 * x3 <= 76)
m.addConstr(0.89 * x2**2 + 0.62 * x4**2 <= 95)
m.addConstr(0.32 * x3**2 + 0.62 * x4**2 <= 35)
m.addConstr(0.65 * x1 + 0.89 * x2 + 0.32 * x3 + 0.62 * x4 <= 35)
m.addConstr(0.39 * x3 + 0.0 * x4 <= 86)
m.addConstr(0.59 * x1 + 0.0 * x4 <= 103)
m.addConstr(0.59 * x1 + 0.39 * x3 + 0.0 * x4 <= 78)
m.addConstr(0.59 * x1 + 0.85 * x2 + 0.39 * x3 <= 128)
m.addConstr(0.85 * x2 + 0.39 * x3 + 0.0 * x4 <= 131)
m.addConstr(0.59 * x1 + 0.85 * x2 + 0.39 * x3 + 0.0 * x4 <= 131)
m.addConstr(0.64 * x2 + 0.89 * x3 <= 73)
m.addConstr(0.23 * x1 + 0.18 * x4 <= 38)
m.addConstr(0.23 * x1 + 0.89 * x3 <= 82)
m.addConstr(0.89 * x3 + 0.18 * x4 <= 44)
m.addConstr(0.23 * x1 + 0.89 * x3 + 0.18 * x4 <= 89)
m.addConstr(0.23 * x1 + 0.64 * x2 + 0.18 * x4 <= 70)
m.addConstr(0.23 * x1 + 0.64 * x2 + 0.89 * x3 + 0.18 * x4 <= 70)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Potatoes: ', x1.varValue)
    print('Hamburgers: ', x2.varValue)
    print('Peanutbutter sandwiches: ', x3.varValue)
    print('Strawberries: ', x4.varValue)
else:
    print('No optimal solution found')
