
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams_of_potassium")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams_of_vitamin_A")


    # Set objective function
    m.setObjective(2.9 * x0 + 5.37 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(15 * x0 + 7 * x1 >= 16, "immune_support_min")
    m.addConstr(14 * x0 + 8 * x1 >= 42, "energy_stability_min")
    m.addConstr(13 * x0 + 17 * x1 >= 23, "digestive_support_min")
    m.addConstr(10 * x0 + 2 * x1 >= 44, "muscle_growth_min")
    m.addConstr(2 * x0 + 12 * x1 >= 40, "cardiovascular_support_min")
    m.addConstr(-3 * x0 + 2 * x1 >= 0, "custom_constraint")

    m.addConstr(15 * x0 + 7 * x1 <= 50, "immune_support_max")
    m.addConstr(14 * x0 + 8 * x1 <= 126, "energy_stability_max")
    m.addConstr(13 * x0 + 17 * x1 <= 65, "digestive_support_max")
    m.addConstr(10 * x0 + 2 * x1 <= 121, "muscle_growth_max")
    m.addConstr(2 * x0 + 12 * x1 <= 59, "cardiovascular_support_max")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('milligrams_of_potassium:', x0.x)
        print('milligrams_of_vitamin_A:', x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
