
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_potassium")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_A")

# Set the objective function
m.setObjective(2.9*x1 + 5.37*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x1 + 7*x2 >= 16, "immune_support_index")
m.addConstr(14*x1 + 8*x2 >= 42, "energy_stability_index")
m.addConstr(13*x1 + 17*x2 >= 23, "digestive_support_index")
m.addConstr(10*x1 + 2*x2 >= 44, "muscle_growth_index")
m.addConstr(2*x1 + 12*x2 >= 40, "cardiovascular_support_index")
m.addConstr(-3*x1 + 2*x2 >= 0, "additional_constraint")
m.addConstr(15*x1 + 7*x2 <= 50, "immune_support_index_upper_bound")
m.addConstr(14*x1 + 8*x2 <= 126, "energy_stability_index_upper_bound")
m.addConstr(13*x1 + 17*x2 <= 65, "digestive_support_index_upper_bound")
m.addConstr(10*x1 + 2*x2 <= 121, "muscle_growth_index_upper_bound")
m.addConstr(2*x1 + 12*x2 <= 59, "cardiovascular_support_index_upper_bound")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of potassium: {x1.x}")
    print(f"Milligrams of vitamin A: {x2.x}")
else:
    print("No optimal solution found")
