
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_potassium", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="milligrams_of_vitamin_A", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(2.9 * x1 + 5.37 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(15 * x1 + 7 * x2 >= 16, name="immune_support_index")
    model.addConstr(14 * x1 + 8 * x2 >= 42, name="energy_stability_index")
    model.addConstr(13 * x1 + 17 * x2 >= 23, name="digestive_support_index")
    model.addConstr(10 * x1 + 2 * x2 >= 44, name="muscle_growth_index")
    model.addConstr(2 * x1 + 12 * x2 >= 40, name="cardiovascular_support_index")
    model.addConstr(-3 * x1 + 2 * x2 >= 0, name="potassium_vitamin_A_tradeoff")
    model.addConstr(15 * x1 + 7 * x2 <= 50, name="immune_support_index_upper_bound")
    model.addConstr(14 * x1 + 8 * x2 <= 126, name="energy_stability_index_upper_bound")
    model.addConstr(13 * x1 + 17 * x2 <= 65, name="digestive_support_index_upper_bound")
    model.addConstr(10 * x1 + 2 * x2 <= 121, name="muscle_growth_index_upper_bound")
    model.addConstr(2 * x1 + 12 * x2 <= 59, name="cardiovascular_support_index_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of potassium: {x1.x}")
        print(f"Milligrams of vitamin A: {x2.x}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
