
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(name="hours worked by Paul")
    x1 = model.addVar(name="hours worked by Dale")


    # Set objective function
    model.setObjective(8.98*x0**2 + 6.8*x0*x1, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3*x0 + 3*x1 >= 4, "c0")
    model.addConstr(4*x0**2 + 3*x1**2 >= 14, "c1")
    model.addConstr(6*x0**2 - x1**2 >= 0, "c2")
    model.addConstr(3*x0**2 + 3*x1**2 <= 7, "c3")
    model.addConstr(3*x0 + 3*x1 <= 7, "c4")
    model.addConstr(4*x0 + 3*x1 <= 18, "c5")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", model.objVal)
        print("hours worked by Paul:", x0.x)
        print("hours worked by Dale:", x1.x)

except gp.GurobiError as e:
    print(f"Gurobi error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check if the model was properly initialized.")

