
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x0 = m.addVar(name="hours_worked_by_Paul")
x1 = m.addVar(name="hours_worked_by_Dale")

# Set the objective function
m.setObjective(8.98 * (x0**2) + 6.8 * x0 * x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x0 >= 3)
m.addConstr(4*x0 >= 4)
m.addConstr(3*x1 >= 3)
m.addConstr(3*x1 >= 3)
m.addConstr(3*x0 + 3*x1 >= 4)
m.addConstr(4*(x0**2) + 3*(x1**2) >= 14)
m.addConstr(6*(x0**2) - (x1**2) >= 0)
m.addConstr(3*(x0**2) + 3*(x1**2) <= 7)
m.addConstr(3*x0 + 3*x1 <= 7)
m.addConstr(4*x0 + 3*x1 <= 18)

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Paul: {x0.x}")
    print(f"Hours worked by Dale: {x1.x}")
else:
    print("No optimal solution found")
