
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="hours_worked_by_Paul", lb=0)  # hours worked by Paul
x2 = m.addVar(name="hours_worked_by_Dale", lb=0)  # hours worked by Dale

# Define the objective function
m.setObjective(8.98 * x1**2 + 6.8 * x1 * x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * x1 + 3 * x2 >= 4, name="paperwork_combined")
m.addConstr(4 * x1**2 + 3 * x2**2 >= 14, name="organization_combined_squared")
m.addConstr(6 * x1**2 - x2**2 >= 0, name="organization_vs_paperwork")
m.addConstr(3 * x1**2 + 3 * x2**2 <= 7, name="paperwork_combined_squared")
m.addConstr(3 * x1 + 3 * x2 <= 7, name="paperwork_combined_limit")
m.addConstr(4 * x1 + 3 * x2 <= 18, name="organization_combined")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Paul: ", x1.varValue)
    print("Hours worked by Dale: ", x2.varValue)
else:
    print("The model is infeasible")
