
from gurobipy import Model, GRB

model = Model("optimization_problem")

# Define variables
x0 = model.addVar(vtype=GRB.INTEGER, name="x0")  # milligrams of vitamin K
x1 = model.addVar(vtype=GRB.INTEGER, name="x1")  # milligrams of zinc
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="x2") # milligrams of vitamin B9
x3 = model.addVar(vtype=GRB.INTEGER, name="x3")  # grams of protein
x4 = model.addVar(vtype=GRB.INTEGER, name="x4")  # milligrams of vitamin B7
x5 = model.addVar(vtype=GRB.CONTINUOUS, name="x5") # milligrams of vitamin B1


# Define objective function
model.setObjective(5*x0 + 3*x1 + 7*x2 + 2*x3 + 6*x4 + 3*x5, GRB.MINIMIZE)

# Define constraints
model.addConstr(13*x0 + 1*x3 >= 78)
model.addConstr(14*x1 + 8*x4 >= 98)
model.addConstr(16*x2 + 8*x4 >= 67)
model.addConstr(14*x1 + 6*x5 >= 110)
model.addConstr(14*x1 + 16*x2 >= 55)
model.addConstr(13*x0 + 6*x5 >= 92)
model.addConstr(14*x1 + 1*x3 >= 79)
model.addConstr(13*x0 + 14*x1 + 16*x2 >= 110)
model.addConstr(14*x1 + 16*x2 + 8*x4 >= 110)
model.addConstr(13*x0 + 14*x1 + 16*x2 >= 86)
model.addConstr(14*x1 + 16*x2 + 8*x4 >= 86)
model.addConstr(13*x0 + 14*x1 + 16*x2 + 1*x3 + 8*x4 + 6*x5 >= 86)
model.addConstr(18*x1 + 19*x5 >= 65)
model.addConstr(3*x0 + 15*x2 >= 87)
model.addConstr(18*x1 + 15*x3 >= 45)
model.addConstr(15*x2 + 19*x5 >= 71)
model.addConstr(15*x2 + 14*x4 + 19*x5 >= 86)
model.addConstr(3*x0 + 15*x3 + 19*x5 >= 86)
# ... (rest of the constraints)
model.addConstr(-9*x2 + 2*x4 >= 0)
model.addConstr(13*x0 + 14*x1 <= 649)
model.addConstr(16*x2 + 6*x5 <= 520)
# ... (rest of the constraints)


# Optimize the model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % model.status)

