
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_model")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="apple pies")
x1 = m.addVar(vtype=GRB.INTEGER, name="bowls of cereal")
x2 = m.addVar(vtype=GRB.INTEGER, name="lemons")
x3 = m.addVar(vtype=GRB.INTEGER, name="potatoes")


# Set objective function
m.setObjective(8.52*x0**2 + 9.92*x1*x2 + 5.41*x3**2 + 2.23*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(8.25*x0**2 + 6.44*x2**2 >= 27)
m.addConstr(0.01*x1 + 16.38*x3 >= 39)
m.addConstr(6.44*x2 + 16.38*x3 >= 32)
m.addConstr(0.01*x1**2 + 6.44*x2**2 >= 43)
m.addConstr(8.25*x0 + 0.01*x1 + 6.44*x2 + 16.38*x3 >= 43)
m.addConstr(19.58*x0 + 14.95*x1 >= 37)
m.addConstr(14.95*x1 + 6.1*x3 >= 28)
m.addConstr(0.47*x2 + 6.1*x3 >= 42)
m.addConstr(19.58*x0 + 14.95*x1 + 0.47*x2 + 6.1*x3 >= 42)
m.addConstr(19.59*x0**2 + 3.73*x3**2 >= 41)
m.addConstr(7.82*x1 + 9.63*x2 >= 30)
m.addConstr(19.59*x0**2 + 9.63*x2**2 >= 59)
m.addConstr(19.59*x0 + 7.82*x1 >= 58)
m.addConstr(19.59*x0 + 7.82*x1 + 9.63*x2 + 3.73*x3 >= 58)
m.addConstr(15.61*x0 + 7.07*x3 >= 32)
m.addConstr(4.98*x2**2 + 7.07*x3**2 >= 50)
m.addConstr(5.29*x1 + 4.98*x2 >= 37)
m.addConstr(15.61*x0 + 4.98*x2 >= 37)
m.addConstr(15.61*x0 + 5.29*x1 + 4.98*x2 + 7.07*x3 >= 37)
m.addConstr(12.97*x0**2 + 12.61*x1**2 >= 73)
m.addConstr(12.97*x0 + 10.67*x3 >= 31)
m.addConstr(12.61*x1**2 + 12.19*x2**2 >= 54)
m.addConstr(12.97*x0 + 12.19*x2 >= 62)
m.addConstr(12.97*x0 + 12.61*x1 + 10.67*x3 >= 39)
m.addConstr(12.61*x1**2 + 12.19*x2**2 + 10.67*x3**2 >= 39)
m.addConstr(12.97*x0 + 12.61*x1 + 12.19*x2 >= 39)
m.addConstr(12.97*x0 + 12.61*x1 + 10.67*x3 >= 52)
m.addConstr(12.61*x1 + 12.19*x2 + 10.67*x3 >= 52)
m.addConstr(12.97*x0 + 12.61*x1 + 12.19*x2 >= 52)
m.addConstr(12.97*x0 + 12.61*x1 + 10.67*x3 >= 42)
m.addConstr(12.61*x1 + 12.19*x2 + 10.67*x3 >= 42)
m.addConstr(12.97*x0 + 12.61*x1 + 12.19*x2 >= 42)
m.addConstr(12.97*x0 + 12.61*x1 + 12.19*x2 + 10.67*x3 >= 42)
m.addConstr(-10*x1 + 10*x3 >= 0)
m.addConstr(5*x1**2 - 9*x2**2 >= 0)
m.addConstr(0.01*x1 + 16.38*x3 <= 183)
m.addConstr(0.01*x1**2 + 6.44*x2**2 <= 72)
m.addConstr(8.25*x0 + 0.01*x1 <= 153)
m.addConstr(6.44*x2**2 + 16.38*x3**2 <= 175)
m.addConstr(8.25*x0 + 0.01*x1 + 6.44*x2 <= 45)
m.addConstr(8.25*x0 + 6.44*x2 + 16.38*x3 <= 162)
m.addConstr(8.25*x0 + 0.01*x1 + 16.38*x3 <= 107)
m.addConstr(14.95*x1**2 + 6.1*x3**2 <= 296)
m.addConstr(19.58*x0 + 6.1*x3 <= 87)
m.addConstr(0.47*x2**2 + 6.1*x3**2 <= 155)
m.addConstr(19.58*x0 + 0.47*x2 <= 246)
m.addConstr(19.58*x0 + 14.95*x1 + 6.1*x3 <= 102)
m.addConstr(19.58*x0**2 + 0.47*x2**2 + 6.1*x3**2 <= 191)
m.addConstr(19.59*x0**2 + 7.82*x1**2 <= 60)
m.addConstr(19.59*x0 + 7.82*x1 + 3.73*x3 <= 177)
m.addConstr(15.61*x0 + 7.07*x3 <= 270)
m.addConstr(12.19*x2 + 10.67*x3 <= 162)
m.addConstr(12.61*x1 + 12.19*x2 + 10.67*x3 <= 211)
m.addConstr(12.97*x0 + 12.19*x2 + 10.67*x3 <= 250)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

