
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
potatoes = m.addVar(lb=0, name="potatoes")
tomatoes = m.addVar(lb=0, name="tomatoes")
protein_bars = m.addVar(lb=0, name="protein_bars")
kiwis = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="kiwis")


# Set objective function
m.setObjective(2*potatoes**2 + potatoes*tomatoes + 7*tomatoes*kiwis + 7*kiwis**2 + 8*kiwis, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*tomatoes + 8*protein_bars <= 49)
m.addConstr(8*potatoes**2 + 6*tomatoes**2 <= 19)
m.addConstr(8*protein_bars + kiwis <= 26)
m.addConstr(8*potatoes + kiwis <= 23)
m.addConstr(8*potatoes + 6*tomatoes + 8*protein_bars + kiwis <= 23)
m.addConstr(5*tomatoes + 7*protein_bars <= 34)
m.addConstr(5*tomatoes + 5*kiwis <= 55)
m.addConstr(5*potatoes**2 + 5*kiwis**2 <= 21)
m.addConstr(5*potatoes + 8*tomatoes + 7*protein_bars + 5*kiwis <= 21)
m.addConstr(6*protein_bars**2 + 2*kiwis**2 <= 55)
m.addConstr(5*potatoes + 8*tomatoes <= 32)
m.addConstr(5*potatoes**2 + 2*kiwis**2 <= 38)
m.addConstr(5*potatoes + 8*tomatoes + 6*protein_bars + 2*kiwis <= 38)
m.addConstr(4*potatoes + 4*protein_bars <= 57)
m.addConstr(3*tomatoes + 7*kiwis <= 68)
m.addConstr(4*protein_bars + 7*kiwis <= 69)
m.addConstr(3*tomatoes**2 + 4*protein_bars**2 <= 62)
m.addConstr(4*potatoes + 3*tomatoes + 4*protein_bars + 7*kiwis <= 62)
m.addConstr(2*potatoes**2 + 8*protein_bars**2 <= 48)
m.addConstr(2*potatoes**2 + 8*protein_bars**2 + 8*kiwis**2 <= 73)
m.addConstr(2*potatoes + 7*tomatoes + 8*protein_bars <= 68)
m.addConstr(2*potatoes + 7*tomatoes + 8*protein_bars + 8*kiwis <= 68)


# Resource Constraints
m.addConstr(8 * potatoes <= 54)
m.addConstr(5 * potatoes <= 83)
m.addConstr(5 * potatoes <= 68)
m.addConstr(4 * potatoes <= 72)
m.addConstr(2 * potatoes <= 79)
m.addConstr(6 * tomatoes <= 54)
m.addConstr(8 * tomatoes <= 83)
m.addConstr(8 * tomatoes <= 68)
m.addConstr(3 * tomatoes <= 72)
m.addConstr(7 * tomatoes <= 79)
m.addConstr(8 * protein_bars <= 54)
m.addConstr(7 * protein_bars <= 83)
m.addConstr(6 * protein_bars <= 68)
m.addConstr(4 * protein_bars <= 72)
m.addConstr(8 * protein_bars <= 79)
m.addConstr(1 * kiwis <= 54)
m.addConstr(5 * kiwis <= 83)
m.addConstr(2 * kiwis <= 68)
m.addConstr(7 * kiwis <= 72)
m.addConstr(8 * kiwis <= 79)


# Additional Constraints
m.addConstr(8*tomatoes + 7*protein_bars >= 12)
m.addConstr(7*protein_bars + 5*kiwis >= 12)
m.addConstr(5*potatoes**2 + 8*tomatoes**2 >= 17)
m.addConstr(5*potatoes + 8*tomatoes + 7*protein_bars >= 13)
m.addConstr(5*potatoes**2 + 7*protein_bars**2 + 5*kiwis**2 >= 13)
m.addConstr(5*potatoes + 8*tomatoes + 7*protein_bars >= 15)
m.addConstr(5*potatoes + 7*protein_bars + 5*kiwis >= 15)
m.addConstr(6*protein_bars + 2*kiwis >= 11)
m.addConstr(5*potatoes + 8*tomatoes >= 6)
m.addConstr(5*potatoes + 6*protein_bars >= 9)
m.addConstr(5*potatoes + 2*kiwis >= 16)
m.addConstr(4*potatoes**2 + 4*protein_bars**2 >= 12)
m.addConstr(4*potatoes + 3*tomatoes >= 14)
m.addConstr(3*tomatoes**2 + 4*protein_bars**2 + 7*kiwis**2 >= 13)
m.addConstr(2*potatoes + 8*protein_bars + 8*kiwis >= 12)
m.addConstr(7*tomatoes**2 + 8*protein_bars**2 + 8*kiwis**2 >= 12)
m.addConstr(2*potatoes**2 + 8*protein_bars**2 + 8*kiwis**2 >= 18)
m.addConstr(7*tomatoes + 8*protein_bars + 8*kiwis >= 18)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

