
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
    vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
    vitamin_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_k")


    # Set objective function
    m.setObjective(5.01 * vitamin_e + 5.67 * vitamin_c + 6.82 * vitamin_k, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2 * vitamin_e + 2 * vitamin_c >= 7, "c0")
    m.addConstr(2 * vitamin_e + 2 * vitamin_c + 5 * vitamin_k >= 5, "c1")
    m.addConstr(6 * vitamin_e - 6 * vitamin_c >= 0, "c2")
    m.addConstr(-4 * vitamin_c + vitamin_k >= 0, "c3")
    m.addConstr(2 * vitamin_e + 5 * vitamin_k <= 21, "c4")
    m.addConstr(2 * vitamin_c + 5 * vitamin_k <= 19, "c5")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_e:', vitamin_e.x)
        print('vitamin_c:', vitamin_c.x)
        print('vitamin_k:', vitamin_k.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
