
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_E")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_C")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_K")

# Set the objective function
m.setObjective(5.01*x1 + 5.67*x2 + 6.82*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 2*x2 >= 7, name="cognitive_performance_index_min")
m.addConstr(2*x1 + 2*x2 + 5*x3 >= 5, name="total_cognitive_performance_min")
m.addConstr(6*x1 - 6*x2 >= 0, name="vitamin_E_over_vitamin_C")
m.addConstr(-4*x2 + x3 >= 0, name="vitamin_C_and_vitamin_K_balance")
m.addConstr(2*x1 + 5*x3 <= 21, name="max_cognitive_performance_x1_x3")
m.addConstr(2*x2 + 5*x3 <= 19, name="max_cognitive_performance_x2_x3")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin E: {x1.x}")
    print(f"Milligrams of Vitamin C: {x2.x}")
    print(f"Milligrams of Vitamin K: {x3.x}")
else:
    print("No optimal solution found.")
