
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milligrams_of_vitamin_E", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="milligrams_of_vitamin_C", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x3 = model.addVar(name="milligrams_of_vitamin_K", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(5.01 * x1 + 5.67 * x2 + 6.82 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2 * x1 <= 25)
    model.addConstr(2 * x2 <= 25)
    model.addConstr(5 * x3 <= 25)
    model.addConstr(2 * x1 + 2 * x2 >= 7)
    model.addConstr(2 * x1 + 2 * x2 + 5 * x3 >= 5)
    model.addConstr(6 * x1 - 6 * x2 >= 0)
    model.addConstr(-4 * x2 + x3 >= 0)
    model.addConstr(2 * x1 + 5 * x3 <= 21)
    model.addConstr(2 * x2 + x3 <= 19)

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin E: {x1.varValue}")
        print(f"Milligrams of vitamin C: {x2.varValue}")
        print(f"Milligrams of vitamin K: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
