
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, name="hours_worked_by_Jean")
    x1 = model.addVar(lb=0, name="hours_worked_by_Laura")


    # Set objective function
    model.setObjective(1*x0**2 + 7*x0*x1 + 1*x1, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(21*x0 + 24*x1 >= 46, "c0")
    model.addConstr(1*x0 + 16*x1 >= 39, "c1")
    model.addConstr(21*x0 + 28*x1 >= 22, "c2")
    model.addConstr(8*x0**2 - 9*x1**2 >= 0, "c3")
    model.addConstr(21*x0**2 + 24*x1**2 <= 90, "c4")
    model.addConstr(1*x0 + 16*x1 <= 80, "c5")
    model.addConstr(21*x0 + 28*x1 <= 70, "c6")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution found:")
        print(f"Hours worked by Jean: {x0.x}")
        print(f"Hours worked by Laura: {x1.x}")
        print(f"Objective value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")
