
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Jean")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Laura")

# Set objective function
m.setObjective(1*x1**2 + 7*x1*x2 + 1*x2**2, GRB.MINIMIZE)

# Add constraints
m.addConstr(21*x1 + 24*x2 >= 46, "paperwork_competence_rating")
m.addConstr(1*x1 + 16*x2 >= 39, "dollar_cost_per_hour_min")
m.addConstr(21*x1 + 28*x2 >= 22, "work_quality_rating_min")
m.addConstr(8*x1**2 - 9*x2**2 >= 0, "squared_constraint")
m.addConstr(441*x1**2 + 576*x2**2 <= 90, "paperwork_competence_squared_max")
m.addConstr(x1 + 16*x2 <= 80, "dollar_cost_per_hour_max")
m.addConstr(21*x1 + 28*x2 <= 70, "work_quality_rating_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Jean: {x1.x}")
    print(f"Hours worked by Laura: {x2.x}")
else:
    print("No optimal solution found")
